/*  Blockiert die gegebene Dauer zusätzlich zu ggf. bereits bestehenden Blockeriungen auf der entsprechenden Hauptressource für
    einen gegebenen AG.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__ab2__block_required_time', _commit => true ); -- Ursprünglicher Funktionsname
SELECT tsystem.function__drop_by_regex( 'resource_timeline__ab2__block_duration', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__ab2__block_duration(
    _ab2_id                 int,                -- AG für den Arbeitszeit auf der Hauptressource blockiert werden soll.
    _blocktime_duration     numeric,            -- Dauer der zu blockierenden effektiven (Arbeits-)Zeit.
    _blocktime_date_start   timestamp = null,    -- Startzeitpunkt, ab dem Blockierungen eingetragen werden sollen.
    _loglevel int DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
) RETURNS bool AS $$
DECLARE
    _prefix   varchar := format( 'resource_timeline__ab2__block_duration AG %L -', _ab2_id );

    _row_count      int;
    _current_time timestamp := localtimestamp( 0 );
    _blocktime_begin timestamp;

    _ab2_record record;

    _load numeric;

BEGIN

    -- Debug
    IF _loglevel >= 4 THEN
        RAISE NOTICE '%',
            format(
                $call$
                    call: scheduling.resource_timeline__ab2__block_duration(
                        _ab2_id => %L,
                        _blocktime_duration => %L,
                        _blocktime_date_start => %L,
                        _loglevel => %L
                    )
                $call$,
                _ab2_id, _blocktime_duration,
                _blocktime_date_start,
                _loglevel
            )
        ;
    END IF;

    -- Debug
    IF _loglevel >= 5 THEN
        RAISE NOTICE '% blocktime_duration:%;', _prefix, make_interval( secs => _blocktime_duration );
    END IF;

    -- Daten des AG holen.
    SELECT a2_id, a2_ab_ix, a2_n, a2w_resource_id_main_terminated AS resource_id_main, a2_at, a2_et
      INTO _ab2_record
      FROM ab2
      JOIN ab2_wkstplan ON a2w_a2_id = a2_id
     WHERE a2_id = _ab2_id;
    -- not found, do nothing
    IF _ab2_record IS NULL THEN
        RAISE NOTICE 'AB2 % not found', _ab2_id;
        RETURN false;
    END IF;
    -- not scheduled, do nothing
    IF _ab2_record.resource_id_main IS NULL THEN
        RAISE NOTICE 'AB2 % not scheduled', _ab2_id;
        RETURN false;
    END IF;

    -- Nur neue Blockierungen setzen, wenn tatsächlich eine Dauer für die zu erstellenden Blockierungen gegeben ist.
    IF _blocktime_duration > 0 THEN

        -- Die Blockierung des Überhangs soll nach dem Ende der ursprünglichen Einterminierung des AG einterminiert werden...
        -- TODO AXS: Klärung: Warum? Wenn Lücken in der Terminierung vorhanden sind, dann können diese doch auch gefüllt werden, Auch wenn diese vor den Task-Einträgen liegen? Auf diese Forderung kann meiner Meinung nach verzichtet werden.
        _blocktime_begin := _ab2_record.a2_et; -- _ab2_record.a2_at;

        -- ... jedoch nicht vor dem aktuellen Zeitpunkt.
        IF ( _blocktime_date_start IS null ) THEN
          _blocktime_begin := greatest( _blocktime_begin, _current_time );
        -- Der Startzeitpunkt ist vorgegeben, ab der die Blockierung des Überhangs einterminiert werden soll.
        -- Dieser sollte aber nicht vor dem Ende der ursprünglichen Terminierung liegen.
        ELSE
            _blocktime_begin := greatest( _blocktime_begin, _blocktime_date_start );
        END IF;

        -- Belastung des ersten Task-Eintrags des AGs auf der Hauptressource bestimmen.
        _load := ifthen( ti_usage = 0.0, 1.0, ti_usage )  -- Die Belastung für Blockierungen ('task.blocktime') soll immer größer 0 sein.
                   FROM scheduling.resource_timeline
                  WHERE ti_type IN ( 'task', 'task.buffer' )
                    AND ti_a2_id = _ab2_id
                        AND ti_resource_id = _ab2_record.resource_id_main
                  ORDER BY ti_date_start
                  LIMIT 1;

        -- insert new blocktimes
        INSERT INTO scheduling.resource_timeline(
            ti_a2_id,
            ti_resource_id, ti_date_start, ti_date_end,
            ti_type, ti_ta_kf, ti_usage
        )
        SELECT
            _ab2_record.a2_id,                                        -- ti_a2_id
            _ab2_record.resource_id_main, slotStartDate, slotEndDate, -- ti_resource_id, ti_date_start, ti_date_end
            'task.blocktime', slotFactor, _load                       -- ti_type, ti_ta_kf, ti_usage
        FROM scheduling.resource_timeline__timeslots__search(
            _resource_id          => _ab2_record.resource_id_main,
            _time_required        => _blocktime_duration,
            _load_required        => 1.0,                           -- TODO AXS: Aktuell haben Blockierungen ein ti_usage von 1. Um partial load zu implementieren Parameter _load_required auf "_load" setzen.
            _timeframe_start      => _blocktime_begin,
            _timeframe_end        => _blocktime_begin + '1 year'::interval,
            _allow_fragmentation  => 'yes',
            _factor_tm_ta         => scheduling.ab2__factor_tm_ta__get( _ab2_record.a2_id ),
            _loglevel             => _loglevel
        );

        /* -- Wenn die Blockierungen in einem Fenster von einem Jahr nicht reinpassen, dann macht die Blockierung nicht wirklich Sinn. -- AXS: Wirklich?
        GET DIAGNOSTICS _row_count = ROW_COUNT;

        IF ( _row_count = 0 ) THEN
            RAISE EXCEPTION
              'blocktime insert failed for ab2_id: %, [ blocktime size: % ]',
              _ab2_record.a2_id,
              _blocktime_duration
            ;
        END IF;
        */

    ELSE

        RAISE NOTICE 'AB2 % no required work %', _ab2_id, _blocktime_duration;
        RETURN false;

    END IF;

    RETURN true;

END $$ LANGUAGE plpgsql;